// ParamDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SSIapp.h"
#include "ParamDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CParamDlg dialog


CParamDlg::CParamDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CParamDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CParamDlg)
	m_edit_paramnum = _T("");
	m_edit_paramval = _T("");
	m_radio_value_size = -1;
	m_radio_hexnum = -1;
	m_radio_hexval = -1;
	m_radio_extension = -1;
	m_PermanentParamChange = FALSE;
	//}}AFX_DATA_INIT

	m_radio_value_size = 0; // byte value
	m_radio_hexnum = 0;
	m_radio_hexval = 0;
	m_radio_extension = 0; // no extension

	m_param_string_len = 0;
	m_bSendRequest = FALSE;
	m_bGetRequest = FALSE;
	
	m_pView = NULL;
}


CParamDlg::CParamDlg(CView* pView)
{
	m_radio_value_size = 0; // byte value
	m_radio_hexnum = 0;
	m_radio_hexval = 0;
	m_radio_extension = 0; // no extension

	m_param_string_len = 0;
	m_bSendRequest = FALSE;
	m_bGetRequest = FALSE;

	m_pView = pView;
}

BOOL CParamDlg::Create(void) 
{
	return CDialog::Create(CParamDlg::IDD);
}

void CParamDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CParamDlg)
	DDX_Text(pDX, IDC_EDIT_PARAMNUM, m_edit_paramnum);
	DDX_Text(pDX, IDC_EDIT_PARAMVAL, m_edit_paramval);
	DDX_Radio(pDX, IDC_RADIO_BYTE, m_radio_value_size);
	DDX_Radio(pDX, IDC_RADIO_HEX, m_radio_hexnum);
	DDX_Radio(pDX, IDC_RADIO_HEXVAL, m_radio_hexval);
	DDX_Radio(pDX, IDC_RADIO_NOEXT, m_radio_extension);
	DDX_Check(pDX, IDC_CHECK_PERMANENT, m_PermanentParamChange);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CParamDlg, CDialog)
	//{{AFX_MSG_MAP(CParamDlg)
	ON_BN_CLICKED(IDC_BUTTON_GET, OnButtonGet)
	ON_BN_CLICKED(IDC_BUTTON_SET, OnButtonSet)
	ON_BN_CLICKED(IDC_RADIO_BYTE, OnRadioByte)
	ON_BN_CLICKED(IDC_RADIO_WORD, OnRadioWord)
	ON_BN_CLICKED(IDC_RADIO_HEX, OnRadioHex)
	ON_BN_CLICKED(IDC_RADIO_HEXVAL, OnRadioHexval)
	ON_BN_CLICKED(IDC_RADIO_DECIMALVAL, OnRadioDecimalval)
	ON_BN_CLICKED(IDC_RADIO_DECIMAL, OnRadioDecimal)
	ON_BN_CLICKED(IDC_BUTTON_NEXT, OnButtonNext)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_DISPLAYPARAM,OnParamNotifyMessage)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CParamDlg message handlers

void CParamDlg::PostNcDestroy() 
{
	// TODO: Add your specialized code here and/or call the base class
	

	CDialog::PostNcDestroy();
	
}

// Set up the param string and length according to the user's input then tell the view that we have a param
// ...request ready to be sent.

void CParamDlg::OnButtonGet() 
{
	// TODO: Add your control notification handler code here
	m_param_string_len = 0;
	BYTE hi_byte;
	BYTE low_byte;
	
	
	m_bSendRequest = TRUE;

	UpdateData(TRUE);	// move the data from the window controls to the member variables

	// no word/byte value indicator when getting a param - just see if this is an extended param num

	switch(m_radio_extension)
	{
		case 0:  // no extension
			break;
		case 1:	// F0
			m_param_string[m_param_string_len++] = 0xf0;
			break;
		case 2:	// F1
			m_param_string[m_param_string_len++] = 0xf1;
			break;
		case 3:	// F2
			m_param_string[m_param_string_len++] = 0xf2;
			break;
		
	}
	
	if(m_radio_hexnum == 0)  // param number was given as a hex value 
	{
		if(VerifyHexString(m_edit_paramnum, 2, &hi_byte, &low_byte)) // 2 hex digits max, high byte is don't care
			m_param_string[m_param_string_len++] = low_byte;
		else
		{
			m_bSendRequest = FALSE;
			MessageBox("Incorrect format for Hex Parameter Number");
		}
	}
	else	// param num was given as a decimal value
	{
		if(VerifyDecimalString(m_edit_paramnum, 3, &hi_byte, &low_byte)) // 3 decimal digits max, high byte is don't care
			m_param_string[m_param_string_len++] = low_byte;
		else
		{
			m_bSendRequest = FALSE;
			MessageBox("Incorrect format for Decimal Parameter Number");
		}

	}


	if(m_bSendRequest)	// we ended up with a valid request so far
	{
		if(low_byte > 0xef)
		{
			if((low_byte != 0xfe) || m_radio_extension)
			{
				MessageBox("Parameter Number is out of range");
				m_bSendRequest = FALSE;
			}
		}
	}

	// We have a valid request, so we can let the view know that it needs to send a param request to the 
	// ...scanner dll.  We let the view send the request because when the connection was opened, the window
	// ...handle that was given to the dll was the view's handle.  The dll will send the result of the param
	// ...request to the view, not to this param dlg window.  So this dialog must communicate requests to the view
	// ...and process result notifications from the view.

	if(m_bSendRequest)	
		if(m_pView != NULL)
			m_pView->SendMessage(WM_GOODBYE, ID_PARAMETERS_GETSCANNERPARAMETER);   // let the view know we're done for now
		
			

	
}



// Set up the param string and param string length then let the view know that there is a param send 
// ...ready to be sent to the scanner.

void CParamDlg::OnButtonSet() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_param_string_len = 0;
	BYTE hi_byte;
	BYTE low_byte;
	int num_digits;
	
	
	m_bSendRequest = TRUE;

	UpdateData(TRUE);	// transfer the data from the screen controls to the member variables

	if(m_radio_value_size) // if non zero, it's a word value rather than a byte value.
		m_param_string[m_param_string_len++] = 0xf4;


	switch(m_radio_extension)	// see if we have an extended param number
	{
		case 0:  // no extension
			break;
		case 1:	// F0
			m_param_string[m_param_string_len++] = 0xf0;
			break;
		case 2:	// F1
			m_param_string[m_param_string_len++] = 0xf1;
			break;
		case 3:	// F2
			m_param_string[m_param_string_len++] = 0xf2;
			break;
		
	}
	
	if(m_radio_hexnum == 0)  // param number was given as a hex value 
	{
		if(VerifyHexString(m_edit_paramnum, 2, &hi_byte, &low_byte)) // 2 hex digits max, high byte is don't care
			m_param_string[m_param_string_len++] = low_byte;
		else
		{
			m_bSendRequest = FALSE;
			MessageBox("Incorrect format for Hex Parameter Number");
		}
	}
	else
	{
		if(VerifyDecimalString(m_edit_paramnum, 3, &hi_byte, &low_byte)) // 3 decimal digits max, high byte is don't care
			m_param_string[m_param_string_len++] = low_byte;
	}


	if(m_bSendRequest) // so far we have valid values
	{
		if(low_byte > 0xef)
		{
			MessageBox("Parameter Number is out of range");
			m_bSendRequest = FALSE;
		}
	}

	if(m_bSendRequest)	// still have valid values
	{
		if(m_radio_hexval == 0)  // param value was given as a hex value 
		{
			num_digits = ((m_radio_value_size) ? 4: 2);
			if(VerifyHexString(m_edit_paramval, num_digits, &hi_byte, &low_byte))
			{
				if(num_digits == 4)
					m_param_string[m_param_string_len++] = hi_byte;
				m_param_string[m_param_string_len++] = low_byte;
			}
			else
			{
				m_bSendRequest = FALSE;
				MessageBox("Incorrect format for Hex Parameter Value");
			}
		}
		else
		{
			num_digits = ((m_radio_value_size) ? 5: 3);
			if(VerifyDecimalString(m_edit_paramval, num_digits, &hi_byte, &low_byte)) 
			{
				if(num_digits == 5)
					m_param_string[m_param_string_len++] = hi_byte;
				m_param_string[m_param_string_len++] = low_byte;
			}
			else
			{
				m_bSendRequest = FALSE;
				MessageBox("Incorrect format for Decimal Parameter Value");
			}

		}
	}

	// We have a valid parameter setting, so we can let the view know that it needs to send a param send cmd to the 
	// ...scanner dll.  We let the view send the command because when the connection was opened, the window
	// ...handle that was given to the dll was the view's handle.  So this dialog must communicate requests to the view
	// ...and let the view take care of communicating with the scanner dll.

	if(m_bSendRequest)
		if(m_pView != NULL)
			m_pView->SendMessage(WM_GOODBYE, ID_PARAMETERS_SETSCANNERPARAMETER);  // let the view know we're done for now
		
			
	
}


// Let the view know that the user pressed cancel and is done for now
void CParamDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	if(m_pView != NULL)
		m_pView->PostMessage(WM_GOODBYE, IDCANCEL);
	else
		CDialog::OnCancel();

}


typedef struct param_value_pairs_tag{
	BYTE extended_paramnum;
	BYTE paramnum;
	WORD value;
	BOOL is_word;
}param_value_pairs_type;

#define MAX_PARAMNUM_VALUE_PAIRS 500
param_value_pairs_type ParamValuePairsArray[MAX_PARAMNUM_VALUE_PAIRS];
WORD nParamValuePairs = -1; // invalid data
int CurParamIndex = -1;

BYTE *CParamDlg::GetNextParamnumValuePair(BYTE * pData, int *nlength, 
							BYTE *pExtNum, BYTE *pNum,  WORD *value, BOOL *bIsWordValue, BOOL *error)
{
	
	BYTE byte;
	int length = *nlength;
	*bIsWordValue = FALSE;
	*pExtNum = 0;
	*pNum = 0;
	*value = 0;
	*error = FALSE;

	if(length == 0)
	{
		*error = TRUE;
		return NULL;
	}
	else
	{
		byte = *pData++;
		length--;
		if((byte == 0xF4) && length)// word value for this parameter
		{
			byte = *pData++; // get paramnum - may be extended paramnum
			length--;
			*bIsWordValue = TRUE;
		}
		if(length == 0)
			*error = TRUE;
		else
		{
			if(   (byte >= 0xf0) && 
				   (length < (2 + ((*bIsWordValue) ? 1: 0)))
				)
				*error = TRUE;
			else if(  (byte < 0xf0) &&  (length < (1  + ((*bIsWordValue) ? 1: 0)  ) ) 
				    )
				*error = TRUE;
			else if(byte >= 0xf0)
			{
				switch(byte)
				{
				case 0xf0:
				case 0xf1:
				case 0xf2:
					*pExtNum = byte;
					break;
				default:
					*error = TRUE;
					break;
				}
				byte = *pData++;
				length--;
			}
		} // end els length was non-zero after parsing off any word indicator
	}// end else length was non-zero on entry

	if(!*error)	// we haven't encountered an errors so far
	{
		BYTE paramnum = byte;
		BYTE paramval = *pData++;
		length--;
		if(*bIsWordValue)
		{
			paramval <<= 8;
			paramval += *pData++;
			length--;
		}
		*pNum = paramnum;  
		*value = paramval;
		*nlength = length;
		return pData;
	}
	else
		return NULL;

}


WORD CParamDlg::ParseParamnumValuePairs(BYTE *pData, int nLength, BOOL *pError)
{

	BYTE *pTemp = pData;

	
	for( nParamValuePairs = 0; nParamValuePairs < MAX_PARAMNUM_VALUE_PAIRS; nParamValuePairs++)
	{
		pTemp = GetNextParamnumValuePair(pTemp, &nLength, 
							&(ParamValuePairsArray[nParamValuePairs].extended_paramnum),
							&(ParamValuePairsArray[nParamValuePairs].paramnum),
							&(ParamValuePairsArray[nParamValuePairs].value),
							&(ParamValuePairsArray[nParamValuePairs].is_word),
							 pError);
		if(*pError)
		{
			nParamValuePairs = -1; // invalid data
			break;
		}
		else if((pTemp == NULL) || (nLength==0))
		{
			nParamValuePairs++;
			break;
		}
	}

	if(*pError)
		return 0;
	else
		return nParamValuePairs;


}

	

// The view window got param input from scanner and the view sent us a message to tell us it has data for us.
// We'll check here for valid data from the scanner and update the window controls according to the data that
// ...was sent to us, or generate an error message if the format was incorrect.
LRESULT CParamDlg::OnParamNotifyMessage(WPARAM dummyW, LPARAM dummyL) 
{
	BYTE *pData = m_param_string;
	int length = (int)m_param_string_len;
	CString msg;
	BOOL bIsWordValue = FALSE;
	BOOL error;

	int nParmsParsed = ParseParamnumValuePairs(pData, length, &error);
	param_value_pairs_type param = ParamValuePairsArray[0];
	CurParamIndex = -1;

	if(error)
		msg.Format("Error Parsing Param Data");
	else if(!nParmsParsed)
		msg.Format("No Parameter Value for Given Param Number");
	else
	{
		CurParamIndex = 0;
		
		switch(param.extended_paramnum)
		{
			case 0xf0:
				m_radio_extension = 1;
				m_radio_value_size = (param.is_word) ? 1: 0;
				break;
			case 0xf1:
				m_radio_extension = 2;
				m_radio_value_size = (param.is_word) ? 1: 0;
				break;
			case 0xf2:
				m_radio_extension = 3;
				m_radio_value_size = (param.is_word) ? 1: 0;
				break;
			default:
				m_radio_extension = 0;
				m_radio_value_size = (param.is_word) ? 1: 0;
				break;
			}
	}// end else length was non-zero on entry

	if(msg.IsEmpty())	// we haven't encountered an errors so far
	{
		BYTE paramnum = param.paramnum;
		WORD paramval = param.value;

		if(m_radio_hexnum == 0) // display paramnum in hex
			m_edit_paramnum.Format("0x%02x",paramnum);
		else
			m_edit_paramnum.Format("%3d",paramnum);

		
		if(m_radio_hexval == 0) // display param value in hex
		{
			if(m_radio_value_size == 0) // display as byte value
				m_edit_paramval.Format("0x%02x",paramval);
			else
				m_edit_paramval.Format("0x%04x",paramval);

		}
		else
		{
			if(m_radio_value_size == 0) // display as byte value
				m_edit_paramval.Format("%3d",paramval);
			else
				m_edit_paramval.Format("%5d",paramval);
		}
		CButton *pButton = (CButton *)GetDlgItem(IDC_BUTTON_NEXT);
		if(nParmsParsed > 1)
			pButton->ShowWindow(SW_SHOW);
		else		
			pButton->ShowWindow(SW_HIDE);

		UpdateData(FALSE);  // move the data (that we have stored in the member variables) to the screen.
	}

	return 0;
}

// change the user instructions whenever the radio button changes
void CParamDlg::OnRadioByte() 
{
	// TODO: Add your control notification handler code here
	CButton *pButton = (CButton *)GetDlgItem(IDC_RADIO_HEXVAL);
	pButton->SetWindowText("Use Hex.  Valid Range 0x00...0xFF");
	pButton = (CButton *)GetDlgItem(IDC_RADIO_DECIMALVAL);
	pButton->SetWindowText("Use Decimal.  Valid Range 0...255");

	
}

// change the user instructions whenever the radio button changes
void CParamDlg::OnRadioWord() 
{
	// TODO: Add your control notification handler code here
	CButton *pButton = (CButton *)GetDlgItem(IDC_RADIO_DECIMALVAL);
	pButton->SetWindowText("Use Decimal.  Valid Range 0...65535");
	
	pButton = (CButton *)GetDlgItem(IDC_RADIO_HEXVAL);
	pButton->SetWindowText("Use Hex.  Valid Range 0x0000...0xFFFF");
	
}


// If the user wants to input values for the param number as hex values, take the decimal value from the screen
// ...and make sure it's valid then convert it to it's ascii hex representation and display in hex.
void CParamDlg::OnRadioHex() 
{
	// TODO: Add your control notification handler code here
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDIT_PARAMNUM);
	CString strDecimal;
	BYTE hi_byte, low_byte;
	

	pEdit->GetWindowText(strDecimal);

	if(VerifyDecimalString(strDecimal, 3, &hi_byte, &low_byte))
	{
		if(hi_byte == 0)
		{
			BYTE paramnum = low_byte;
			m_edit_paramnum.Format("0x%02x",paramnum);
			pEdit->SetWindowText(m_edit_paramnum);
		}
		else
		{
			pEdit->SetWindowText("");
			m_edit_paramnum = "";
		}
	}
	else
	{
		pEdit->SetWindowText("");
		m_edit_paramnum = "";
	}

}


// If the user wants to input values for the param number as decimal values, take the hex value from the screen
// ...and make sure it's valid then convert it to it's ascii decimal representation and display in decimal format.
void CParamDlg::OnRadioDecimal() 
{
	// TODO: Add your control notification handler code here


	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDIT_PARAMNUM);
	CString strHex;
	BYTE hi_byte, low_byte;
	

	pEdit->GetWindowText(strHex);

	if(VerifyHexString(strHex, 2, &hi_byte, &low_byte))
	{

		BYTE paramnum = low_byte;
		m_edit_paramnum.Format("%3d",paramnum);
		pEdit->SetWindowText(m_edit_paramnum);
	}
	else
	{
		pEdit->SetWindowText("");
		m_edit_paramnum = "";
	}

	
}


// If the user wants to input values for the param value as hex values, take the decimal value from the screen
// ...and make sure it's valid then convert it to it's ascii hex representation and display in hex.
void CParamDlg::OnRadioHexval() 
{
	// TODO: Add your control notification handler code here
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDIT_PARAMVAL);
	CString strDecimal;
	BYTE hi_byte, low_byte;
	

	pEdit->GetWindowText(strDecimal);


	if(((CButton *)GetDlgItem(IDC_RADIO_BYTE))->GetCheck())
		m_radio_value_size = 0;
	else
		m_radio_value_size = 1;

	if(m_radio_value_size)  // word value
	{
		if(VerifyDecimalString(strDecimal, 5, &hi_byte, &low_byte))
		{

			unsigned paramval = (hi_byte << 8) | low_byte;
			m_edit_paramval.Format("0x%04x",paramval);
			pEdit->SetWindowText(m_edit_paramval);
		}
		else
		{
			pEdit->SetWindowText("");
			m_edit_paramnum = "";
		}
	}
	else
	{
		if(VerifyDecimalString(strDecimal, 3, &hi_byte, &low_byte))
		{
			if(hi_byte == 0)
			{
				m_edit_paramval.Format("0x%02x",low_byte);
				pEdit->SetWindowText(m_edit_paramval);
			}
			else
			{
				pEdit->SetWindowText("");
				m_edit_paramnum = "";
			}
		}
		else
		{
			pEdit->SetWindowText("");
			m_edit_paramnum = "";
		}
	}


	
}


// If the user wants to input values for the param value as decimal values, take the hex value from the screen
// ...and make sure it's valid then convert it to it's ascii decimal representation and display in decimal.
void CParamDlg::OnRadioDecimalval() 
{
	// TODO: Add your control notification handler code here
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDIT_PARAMVAL);
	CString strHex;
	BYTE hi_byte, low_byte;
	

	pEdit->GetWindowText(strHex);


	if(((CButton *)GetDlgItem(IDC_RADIO_BYTE))->GetCheck())
		m_radio_value_size = 0;
	else
		m_radio_value_size = 1;

	if(m_radio_value_size)  // word value
	{
		if(VerifyHexString(strHex, 4, &hi_byte, &low_byte))
		{

			unsigned paramval = (hi_byte << 8) | low_byte;
			m_edit_paramval.Format("%5d",paramval);
			pEdit->SetWindowText(m_edit_paramval);
		}
		else
		{
			pEdit->SetWindowText("");
			m_edit_paramnum = "";
		}
	}
	else
	{
		if(VerifyHexString(strHex, 2, &hi_byte, &low_byte))
		{
			if(hi_byte == 0)
			{
				m_edit_paramval.Format("%3d",low_byte);
				pEdit->SetWindowText(m_edit_paramval);
			}
			else
			{
				pEdit->SetWindowText("");
				m_edit_paramnum = "";
			}
		}
		else
		{
			pEdit->SetWindowText("");
			m_edit_paramnum = "";
		}
	}

	
}

// Checks the input format to make sure the input consists of only ascii digits and that there are at most 
// ...maxDigits.  Converts the ascii representation to the value and returns the value to the user in
// ...hiByte, loByte.  If a valid value was stored, the function returns TRUE, o/w it returns FALSE.
BOOL CParamDlg::VerifyDecimalString(CString strNum, int maxDigits, BYTE *hiByte, BYTE *loByte)
{
	int i;
	unsigned val = 0;
	int length;
	char ch;
	CString res = strNum;

	res.TrimLeft(); // remove whitespace
	res.TrimRight();

	if(res.IsEmpty())
		return FALSE;

	length = res.GetLength();
	if(length <= maxDigits)
	{
		val = 0;
		for( i = 0; i < length; i++)
		{
			val *= 10;

			ch = res.GetAt(i);
			if((ch >= '0') && (ch <= '9'))
				val += (ch - '0');
			else
			{
				i = 0;
				break;
			}

		}
		if(i)
		{
			*hiByte = (val & 0xff00) >> 8;
			*loByte = (val & 0x00ff);
			if(val <= 0xffff)
				return TRUE;
		}
	}
	
	

	return FALSE;

}


// Checks the input format to make sure the input consists of only ascii hex digits (optionally preceeded by 0x 
// ... or an x alone) and that there are at most 
// ...maxDigits.  Converts the ascii representation to the value and returns the value to the user in
// ...hiByte, loByte.  If a valid value was stored, the function returns TRUE, o/w it returns FALSE.
BOOL CParamDlg::VerifyHexString(CString strNum, int maxDigits, BYTE *hiByte, BYTE *loByte)
{
	int i;
	unsigned val = 0;
	int length;
	char ch;

	CString res = strNum;
	res.TrimLeft();			// remove whitespace
	res.TrimRight();

	if(res.IsEmpty())
		return FALSE;



	res.TrimLeft('0');		// remove leading zeros
	if(res.IsEmpty())			// if all zeros - value is zero
	{
		*hiByte = 0;
		*loByte = 0;
		return TRUE;
	}

	res.MakeUpper();			// not all zeros - leading zeros are gone 
	length = res.GetLength();

	if(res.GetAt(0) == 'X')	// input string was of the format 0x... or simply x...
	{
		if(length > 1)			// if input began with hex indicator, it must be followed by digits
		{
			res.SetAt(0,'0');	// replace the hex indicator with a leading zero.
			maxDigits += 1;	// if maxDigits was set to 2, we'll allow 3 now, since we stuck in a leading zero
		}							// if it was 4, then we'll allow 5 now.  It won't affect the resulting value.
		else
			return FALSE;
	}


	
	if(length <= maxDigits)
	{
		val = 0;
		

		for( i = 0; i < length; i++)
		{
			val <<= 4;
			ch = res.GetAt(i);
			if((ch >= '0') && (ch <= '9')) 
				val |= (ch - '0');
			else if((ch >= 'A') && (ch <= 'F'))
				val |= (ch - 55);
			else
			{
				i = 0;
				break;
			}
		}

		if(i)
		{
			*hiByte = (val & 0xff00) >> 8;
			*loByte = (val & 0x00ff);
			return TRUE;
		}
	}
	
	return FALSE;

}

void CParamDlg::OnButtonNext() 
{
	// TODO: Add your control notification handler code here
	if(CurParamIndex < (nParamValuePairs)) // should always be true 
	{
		
		param_value_pairs_type param = ParamValuePairsArray[CurParamIndex++];

		switch(param.extended_paramnum)
		{
			case 0xf0:
				m_radio_extension = 1;
				m_radio_value_size = (param.is_word) ? 1: 0;
				break;
			case 0xf1:
				m_radio_extension = 2;
				m_radio_value_size = (param.is_word) ? 1: 0;
				break;
			case 0xf2:
				m_radio_extension = 3;
				m_radio_value_size = (param.is_word) ? 1: 0;
				break;
			default:
				m_radio_extension = 0;
				m_radio_value_size = (param.is_word) ? 1: 0;
				break;
			}
	

		BYTE paramnum = param.paramnum;
		WORD paramval = param.value;

		if(m_radio_hexnum == 0) // display paramnum in hex
			m_edit_paramnum.Format("0x%02x",paramnum);
		else
			m_edit_paramnum.Format("%3d",paramnum);

		
		if(m_radio_hexval == 0) // display param value in hex
		{
			if(m_radio_value_size == 0) // display as byte value
				m_edit_paramval.Format("0x%02x",paramval);
			else
				m_edit_paramval.Format("0x%04x",paramval);

		}
		else
		{
			if(m_radio_value_size == 0) // display as byte value
				m_edit_paramval.Format("%3d",paramval);
			else
				m_edit_paramval.Format("%5d",paramval);
		}
		CButton *pButton = (CButton *)GetDlgItem(IDC_BUTTON_NEXT);
		if(CurParamIndex >= (nParamValuePairs ) )		
			pButton->ShowWindow(SW_HIDE);

		UpdateData(FALSE);  // move the data (that we have stored in the member variables) to the screen.
	}
	
}
